<?php
    require_once(__DIR__.'/360safe/360webscan.php');
    if($_GET['action'] == 'serverInfo'){
        $unixTimestamp = time();
        $serverUptime =  getUpTime();
        $serverLoad = GetLoad();
        $cpuUsage = GetCPUInfo();
        $memoryInfo = GetMem();
        $diskAll = disk_total_space(__DIR__);
        $diskFree =  disk_free_space(__DIR__) ;
        $serverInfo = array(  
            'serverTime' => date('Y-m-d H:i:s', $unixTimestamp),  
            'serverUptime' => array(  
                'days' => $serverUptime['days'],  
                'hours' => $serverUptime['hours'],  
                'mins' => $serverUptime['mins'],  
                'secs' => $serverUptime['secs']  
            ),  
            'serverUtcTime' => date('Y/m/d H:i:s', $unixTimestamp),  
            'diskUsage' => array(  
                'value' => $diskAll - $diskFree,  
                'max' => $diskAll
            )
        );
        $serverStatus = array(  
            'sysLoad' => array($serverLoad['1m'], $serverLoad['5m'], $serverLoad['15m']),  
            'cpuUsage' => array(  
                'user' => $cpuUsage['user'],  
                'nice' => $cpuUsage['nice'],  
                'sys' => $cpuUsage['sys'],  
                'idle' => $cpuUsage['idle']  
            ),  
            'memRealUsage' => array(  
                'value' => $memoryInfo['mRealUsed'],  
                'max' => $memoryInfo['mTotal']  
            ),  
            'memBuffers' => array(  
                'value' => $memoryInfo['mBuffers'],  
                'max' => $memoryInfo['mTotal']  
            ),  
            'memCached' => array(  
                'value' => $memoryInfo['mCached'],  
                'max' => $memoryInfo['mTotal'] - $memoryInfo['mRealUsed']  
            ),  
            'swapUsage' => array(  
                'value' => $memoryInfo['swapUsed'],  
                'max' => $memoryInfo['swapTotal']  
            ),  
            'swapCached' => array(  
                'value' => $memoryInfo['swapCached'],  
                'max' => $memoryInfo['swapTotal']  
            )  
        );
        $networkStats = array(  
            'networks' => GetNetwork()
        );
        $output = array(  
            'serverInfo' => $serverInfo,  
            'serverStatus' => $serverStatus,  
            'networkStats' => $networkStats,
            'userInfo' => $userInfoNum
        );  
        echo json_encode($output); 
        exit();
    }

?>

<!DOCTYPE html>
    <html lang="zh-CN">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0,maximum-scale=1.0, user-scalable=no"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1"/>
    <meta name="renderer" content="webkit">
    <meta http-equiv="Cache-Control" content="public"/> 
    <title>服务器状态</title>
    <!--MDUI 腾讯云CDN-->
    <link href="//www.88ipa.com/assets/MDUI/css/mdui.min.css?v1.3.4" rel="stylesheet">
    <script src="//www.88ipa.com/assets/MDUI/js/mdui.min.js?v1.3.4"></script>
    <!--layUI 腾讯云CDN-->
    <link href="//www.88ipa.com/assets/layUI/css/layui.css?v1.3.4" rel="stylesheet">
    <script src="//www.88ipa.com/assets/layUI/layui.js?v1.3.4" ></script>
    <!--JQuery 腾讯云CDN-->
    <script src="//www.88ipa.com/assets/JQuery/jquery-3.2.1.min.js?v1.3.4" ></script>
    <script src="//www.88ipa.com/assets/JQuery/jquery.pjax.js?v1.3.4"></script>
    <style>
        .iosipa-order-state-1{
            background: #4CAF50;
            color: #ffffff;
            width: 50px;
            padding: 2px;
            border-radius: 4px;
            text-align: center;
        } 
        .iosipa-order-state-2{
            background: #795548;
            color: #ffffff;
            width: 55px;
            padding: 2px;
            border-radius: 4px; 
            text-align: center;
        } 
        .iosipa-order-state-3{
            background: #3F51B5;
            color: #ffffff;
            width: 50px;
            padding: 2px;
            border-radius: 4px; 
            text-align: center;
        } 
        .iosipa-order-state-4{
            background: #FF9800;
            color: #ffffff;
            width: 50px;
            padding: 2px;
            border-radius: 4px; 
            text-align: center;
        } 
    </style>
</head>
<body class="mdui-color-indigo-50 mdui-theme-primary-indigo mdui-theme-accent-pink ">
    <div class="mdui-center">
        
        
        <div class="mdui-container mdui-m-t-1"> 
          <div class="mdui-typo-display-1">服务器状态</div>
        </div>  
        <div class="mdui-container mdui-m-t-2">
            
            <div class="mdui-row-xs-1 mdui-row-sm-2 mdui-row-md-3">
                <div class="mdui-col">
                    
                    <div class="mdui-typo-title mdui-m-t-1">运行状态</div>
                    <div class="mdui-divider"></div>
                    <div class="mdui-m-t-2"> 
                        <div class="mdui-clearfix mdui-typo-body-1 mdui-m-t-1">
                          <div class="mdui-float-left">CPU占用 <span class="iosipa-order-state-1">4核心</span></div>
                          <div id="cpu" class="mdui-float-right">100%</div>
                        </div>
                        <div class="layui-progress  mdui-m-t-1 " lay-filter="cpu">
                          <div id="cpu_css" class="layui-progress-bar layui-bg-red" lay-percent="100%"></div>
                        </div>
                    </div>
                    
                    <div class="mdui-m-t-2"> 
                        <div class="mdui-clearfix mdui-typo-body-1 mdui-m-t-1">
                          <div class="mdui-float-left">内存占用 <span id="memory" class="iosipa-order-state-1">NULL</span></div>
                          <div id="memory_data" class="mdui-float-right">100%</div>
                        </div>
                        <div class="layui-progress  mdui-m-t-1 " lay-filter="memory_data">
                          <div id="memory_css" class="layui-progress-bar layui-bg-red" lay-percent="100%"></div>
                        </div>
                    </div>
                    
                    <div class="mdui-m-t-2"> 
                        <div class="mdui-clearfix mdui-typo-body-1 mdui-m-t-1">
                          <div class="mdui-float-left">硬盘占用 <span id="disk_data" class="iosipa-order-state-1">NULL</span></div>
                          <div id="disk" class="mdui-float-right">100%</div>
                        </div>
                        <div class="layui-progress  mdui-m-t-1 " lay-filter="disk_data">
                          <div id="disk_css" class="layui-progress-bar layui-bg-red" lay-percent="100%"></div>
                        </div>
                    </div>
                    
                    <div class="mdui-m-t-2"> 
                        <div class="mdui-clearfix mdui-typo-body-1 mdui-m-t-1">
                          <div class="mdui-float-left">内存缓存 <span id="memCached_data" class="iosipa-order-state-1">NULL</span></div>
                          <div id="memCached" class="mdui-float-right">100%</div>
                        </div>
                        <div class="layui-progress  mdui-m-t-1 " lay-filter="memCached_data">
                          <div id="memCached_css" class="layui-progress-bar layui-bg-red" lay-percent="100%"></div>
                        </div>
                    </div>
                    
                    <div class="mdui-m-t-2"> 
                        <div class="mdui-clearfix mdui-typo-body-1 mdui-m-t-1">
                          <div class="mdui-float-left">Swap缓存 <span id="Swap_data" class="iosipa-order-state-1">NULL</span></div>
                          <div id="Swap" class="mdui-float-right">100%</div>
                        </div>
                        <div class="layui-progress  mdui-m-t-1 " lay-filter="Swap_data">
                          <div id="Swap_css" class="layui-progress-bar layui-bg-red" lay-percent="100%"></div>
                        </div>
                    </div>
                    
                    <div class="mdui-m-t-2"> 
                        <div class="mdui-clearfix mdui-typo-body-1 mdui-m-t-1">
                          <div class="mdui-float-left">系统负载 <span id="state_data" class="iosipa-order-state-1">NULL</span></div>
                          <div id="state_bfb" class="mdui-float-right">100%</div>
                        </div>
                        <div class="layui-progress  mdui-m-t-1 " lay-filter="state_data">
                          <div id="state_css" class="layui-progress-bar layui-bg-red" lay-percent="100%"></div>
                        </div>
                    </div>
                </div>
                
                
                <div class="mdui-col">
                    <div class="mdui-typo-title mdui-m-t-3">网络状态</div>
                    <div class="mdui-divider"></div> 
                    
                
                    <div class="mdui-clearfix mdui-typo-body-2 mdui-m-t-1">
                      <div class="mdui-float-left">IO</div>
                      <div id="io" class="mdui-float-right"><span class="iosipa-order-state-3">NULL</span></div>
                    </div>
                    
                    <div class="mdui-clearfix mdui-typo-body-2 mdui-m-t-1">
                      <div class="mdui-float-left">实时IO</div>
                      <div id="io1" class="mdui-float-right"><span class="iosipa-order-state-3">NULL</span></div>
                    </div>
                    
                    <div class="mdui-clearfix mdui-typo-body-2 mdui-m-t-1">
                      <div class="mdui-float-left">网络</div>
                      <div id="eth" class="mdui-float-right"><span class="iosipa-order-state-3">NULL</span></div>
                    </div>
                     
                    <div class="mdui-clearfix mdui-typo-body-2 mdui-m-t-1">
                      <div class="mdui-float-left">实时网络</div>
                      <div id="eth1" class="mdui-float-right"><span class="iosipa-order-state-3">NULL</span></div>
                    </div>
                    
                    <div class="mdui-clearfix mdui-typo-body-2 mdui-m-t-1">
                      <div class="mdui-float-left">服务器时间</div>
                      <div id="time" class="mdui-float-right"><span class="iosipa-order-state-4">NULL</span></div>
                    </div>
                    
                    <div class="mdui-clearfix mdui-typo-body-2 mdui-m-t-1">
                      <div class="mdui-float-left">WEB服务器</div>
                      <div id="time" class="mdui-float-right"><span class="iosipa-order-state-3"><?php echo $_SERVER['SERVER_SOFTWARE']; ?></span></div>
                    </div>
                    
                    <div class="mdui-clearfix mdui-typo-body-2 mdui-m-t-1">
                      <div class="mdui-float-left">通信协议</div>
                      <div id="time" class="mdui-float-right"><span class="iosipa-order-state-3"><?php echo $_SERVER['SERVER_PROTOCOL']; ?></span></div>
                    </div>
                    
                    <div class="mdui-clearfix mdui-typo-body-2 mdui-m-t-1">
                      <div class="mdui-float-left">PHP版本</div>
                      <div id="time" class="mdui-float-right"><span class="iosipa-order-state-3"><?php echo PHP_VERSION;?></span></div>
                    </div>
                </div>    
                
                <div class="mdui-col">
                            
                    <div class="mdui-typo-title mdui-m-t-3">访客信息</div>
                    <div class="mdui-divider"></div>
                    <div class="mdui-m-t-2  mdui-m-b-5">
                    
                    <div class="mdui-clearfix mdui-typo-body-1 mdui-m-t-1">
                      <div class="mdui-float-left">持续运行</div>
                      <div id="u_time" class="mdui-float-right"><span class="iosipa-order-state-2">NULL</span></div>
                    </div>
                    
                    <div class="mdui-clearfix mdui-typo-body-1 mdui-m-t-1">
                      <div class="mdui-float-left">您的IP</div>
                      <div id="ip" class="mdui-float-right"><span class="iosipa-order-state-2">NULL</span></div>
                    </div>
                    
                    <div class="mdui-clearfix mdui-typo-body-1 mdui-m-t-1">
                      <div class="mdui-float-left">网络地址</div>
                      <div id="address" class="mdui-float-right"><span class="iosipa-order-state-2">NULL</span></div>
                    </div>
    
                    <div class="mdui-clearfix mdui-typo-body-1 mdui-m-t-1">
                      <div class="mdui-float-left">浏览器信息</div>
                      <div id="b" class="mdui-float-right"><span class="iosipa-order-state-2">NULL</span></div>
                    </div>
                    
                    
                    <div class="mdui-clearfix mdui-typo-body-1 mdui-m-t-1">
                      <div class="mdui-float-left">您的设备</div>
                      <div id="sys" class="mdui-float-right"><span class="iosipa-order-state-2">NULL</span></div>
                    </div>   
                    
                    <div class="mdui-clearfix mdui-typo-body-1 mdui-m-t-1">
                      <div class="mdui-float-left">请求方式</div>
                      <div class="mdui-float-right"><span class="iosipa-order-state-2"><?php echo $_SERVER['REQUEST_METHOD'];?></span></div>
                    </div>
                    <div class="mdui-clearfix mdui-typo-body-1 mdui-m-t-1">
                      <div class="mdui-float-left">服务语言</div>
                      <div class="mdui-float-right"><span class="iosipa-order-state-2"><?php echo $_SERVER['HTTP_ACCEPT_LANGUAGE'];?></span></div>
                    </div>
                    <div class="mdui-clearfix mdui-typo-body-1 mdui-m-t-1">
                      <div class="mdui-float-left">您的设备时间</div>
                      <div id="sys_times" class="mdui-float-right"><span class="iosipa-order-state-2">NULL</span></div>
                    </div>
                </div>
            </div>
        
            
            
        
    </div>
    
    
    
    </div>
</body>

<script>
var cpus = 4;
var stateUrl = '/serverInfo/';
var se_rx;
var se_tx;
var si_rx;
var si_tx;
function returnFloat(value){
    return value.toFixed(2)+'%';
}
function floats(value){
    return value.toFixed(2);
}
function getPercent(curNum, totalNum, isHasPercentStr) {
    curNum = parseFloat(curNum);
    totalNum = parseFloat(totalNum);

    if (isNaN(curNum) || isNaN(totalNum)) {
        return 'Error';
    }

    return isHasPercentStr ?
        totalNum <= 0 ? '0%' : (Math.round(curNum / totalNum * 10000) / 100.00 + '%') :
        totalNum <= 0 ? 0 : (Math.round(curNum / totalNum * 10000) / 100.00  + '%');
}
function getPercents(curNum, totalNum, isHasPercentStr) {
    curNum = parseFloat(curNum);
    totalNum = parseFloat(totalNum);

    if (isNaN(curNum) || isNaN(totalNum)) {
        return 'Error';
    }

    return isHasPercentStr ?
        totalNum <= 0 ? '0%' : (Math.round(curNum / totalNum * 10000) / 100.00) :
        totalNum <= 0 ? 0 : (Math.round(curNum / totalNum * 10000) / 100.00);
}
function setSize(value,d){
    switch (d) {
        case 'bit':
            return bit = value*8;
            break;
        case 'bytes':
            return value;
            break;
        case 'kb':
            return value/1024;
            break;
        case 'mb':
            return value/1024/1024;
            break;
        case 'gb':
            return value/1024/1024/1024;
            break;
        case 'tb':
            return value/1024/1024/1024/1024;
            break;
    }
}
function ForDight(Dight){ 
    if (Dight < 0){
        var Last = 0+"B/s";
    }else if (Dight < 1024){
        var Last = setSize(Dight,'bytes').toFixed(0)+"B/s";
    }else if (Dight < 1048576){
        var Last = floats(setSize(Dight,'kb'))+"K/s";
    }else{
        var Last = floats(setSize(Dight,'mb'))+"MB/s";
    }
    return Last; 
}
function state(){
    $.ajax({
        url: stateUrl,
        type: 'get',
        dataType: 'json',
        data: {
            action:'serverInfo',
        }, 
        beforeSend:function(){
        },
        complete:function(){
        },
        error: function() {
        }, 
        success: function (data) { 
            var cpu = data.serverStatus.cpuUsage['user']+data.serverStatus.cpuUsage['nice']+data.serverStatus.cpuUsage['sys'];
            $("#cpu").html(returnFloat(cpu)); 
            layui.element.progress('cpu', returnFloat(cpu))
            if(cpu >= 90){
                $("#cpu_css").removeClass();
                $("#cpu_css").addClass("layui-progress-bar layui-bg-red");
            }else if(cpu >= 60){
                $("#cpu_css").removeClass();
                $("#cpu_css").addClass("layui-progress-bar layui-bg-orange");
            }else{
                $("#cpu_css").removeClass();
                $("#cpu_css").addClass("layui-progress-bar");
            }
            var memory_value = data.serverStatus.memRealUsage['value'];
            var memory_max = data.serverStatus.memRealUsage['max'];
            //设置内存 10%
            $("#memory_data").html(getPercent(memory_value,memory_max,memory_value));
            window.RemData = getPercents(memory_value,memory_max,memory_value);
            //设置内存进度条
            layui.element.progress('memory_data', getPercent(memory_value,memory_max,memory_value))
            //颜色修改
            var me = getPercents(memory_value,memory_max,memory_value);
            if(me >= 90){
                $("#memory_css").removeClass();
                $("#memory_css").addClass("layui-progress-bar layui-bg-red");
            }else if(me >= 60){
                $("#memory_css").removeClass();
                $("#memory_css").addClass("layui-progress-bar layui-bg-orange");
            }else{
                $("#memory_css").removeClass();
                $("#memory_css").addClass("layui-progress-bar");
            }
            if(floats(setSize(memory_value,'mb'))>1024){
                var memory_data_value = floats(setSize(memory_value,'gb'))+"GB";
            } else{
                var memory_data_value = floats(setSize(memory_value,'mb'))+"MB";
            }
            if(floats(setSize(memory_max,'mb'))>1024){
                var memory_data_max = floats(setSize(memory_max,'gb'))+"GB";
            } else{
                var memory_data_max = floats(setSize(memory_max,'mb'))+"MB";
            }
            //设置内存 MB/MB
            $("#memory").html(memory_data_value+" / "+memory_data_max);
            var disk_value = data.serverInfo.diskUsage['value'];
            var disk_max = data.serverInfo.diskUsage['max'];
            $("#disk").html(getPercent(disk_value,disk_max,disk_value));
            //设置硬盘进度条
            layui.element.progress('disk_data', getPercent(disk_value,disk_max,disk_value)) 
            var dk = getPercents(disk_value,disk_max,disk_value);
            if(dk >= 90){
                $("#disk_css").removeClass();
                $("#disk_css").addClass("layui-progress-bar layui-bg-red");
            }else if(dk >= 60){
                $("#disk_css").removeClass();
                $("#disk_css").addClass("layui-progress-bar layui-bg-orange");
            }else{
                $("#disk_css").removeClass();
                $("#disk_css").addClass("layui-progress-bar");
            } 
            if(floats(setSize(disk_value,'mb'))>1024){
                var disk_data_value = floats(setSize(disk_value,'gb'))+"GB";
            } else{
                var disk_data_value = floats(setSize(disk_value,'mb'))+"MB";
            }
            if(floats(setSize(disk_max,'mb'))>1024){
                var disk_data_max = floats(setSize(disk_max,'gb'))+"GB";
            } else{
                var disk_data_max = floats(setSize(disk_max,'mb'))+"MB";
            }
            $("#disk_data").html(disk_data_value+" / "+disk_data_max);
            var memCached_value = data.serverStatus.memCached['value'];
            var memCached_max = data.serverStatus.memCached['max'];
            $("#memCached").html(getPercent(memCached_value,memCached_max,memCached_value));
            //设置内存缓存进度条
            layui.element.progress('memCached_data', getPercent(memCached_value,memCached_max,memCached_value)) 
            var mem = getPercents(memCached_value,memCached_max,memCached_value);
            if(mem >= 90){
                $("#memCached_css").removeClass();
                $("#memCached_css").addClass("layui-progress-bar layui-bg-red");
            }else if(mem >= 60){
                $("#memCached_css").removeClass();
                $("#memCached_css").addClass("layui-progress-bar layui-bg-orange");
            }else{
                $("#memCached_css").removeClass();
                $("#memCached_css").addClass("layui-progress-bar");
            }
            if(floats(setSize(memCached_value,'mb'))>1024){
                var memCached_data_value = floats(setSize(memCached_value,'gb'))+"GB";
            } else{
                var memCached_data_value = floats(setSize(memCached_value,'mb'))+"MB";
            }
            if(floats(setSize(memCached_max,'mb'))>1024){
                var memCached_data_max = floats(setSize(memCached_max,'gb'))+"GB";
            } else{
                var memCached_data_max = floats(setSize(memCached_max,'mb'))+"MB";
            }
            $("#memCached_data").html(memCached_data_value+" / "+memCached_data_max);
            
            
            var swap_value = data.serverStatus.swapUsage['value'];
            var swap_max = data.serverStatus.swapUsage['max'];

            var swapNum = getPercent(swap_value,swap_max,swap_value);
            $("#Swap").html(swapNum);
            //swap进度条
            layui.element.progress('Swap_data', swapNum) 
            
            
            var swa = getPercents(swap_value,swap_max,swap_value);
            if(swa >= 90){
                $("#Swap_css").removeClass();
                $("#Swap_css").addClass("layui-progress-bar layui-bg-red");
            }else if(swa >= 60){
                $("#Swap_css").removeClass();
                $("#Swap_css").addClass("layui-progress-bar layui-bg-orange");
            }else{
                $("#Swap_css").removeClass();
                $("#Swap_css").addClass("layui-progress-bar");
            }
            
            if(floats(setSize(swap_value,'mb'))>1024){
                var swap_data_value = floats(setSize(swap_value,'gb'))+"GB";
            } else{
                var swap_data_value = floats(setSize(swap_value,'mb'))+"MB";
            }
            if(floats(setSize(swap_max,'mb'))>1024){
                var swap_data_max = floats(setSize(swap_max,'gb'))+"GB";
            } else{
                var swap_data_max = floats(setSize(swap_max,'mb'))+"MB";
            }
            $("#Swap_data").html(swap_data_value+" / "+swap_data_max);
            var state = "";
            for(var i = 0; i < data.serverStatus.sysLoad.length ; i++){
                state += '<span class="iosipa-order-state-1">'+data.serverStatus.sysLoad[i]+'</span>&nbsp;'
            }
            $("#state_data").html(state); //三个负载  
            var state_s = getPercent(data.serverStatus.sysLoad[0],cpus,data.serverStatus.sysLoad[0]); 
            $("#state_bfb").html(state_s); //数值 百分比 
            //负载状态进度条
            layui.element.progress('state_data', state_s) 
            var sta = getPercents(data.serverStatus.sysLoad[0],cpus,data.serverStatus.sysLoad[0]);

            if(sta >= 90){
                $("#state_css").removeClass();
                $("#state_css").addClass("layui-progress-bar layui-bg-red");
            }else if(sta >= 60){
                $("#state_css").removeClass();
                $("#state_css").addClass("layui-progress-bar layui-bg-orange");
            }else{
                $("#state_css").removeClass();
                $("#state_css").addClass("layui-progress-bar");
            }
            
            $("#time").html('<span class="iosipa-order-state-4">'+data.serverInfo.serverTime+'</span>');
            
            $("#u_time").html('<span class="iosipa-order-state-2">'+data.serverInfo.serverUptime["days"]+' 天'+data.serverInfo.serverUptime["hours"]+' 时 '+data.serverInfo.serverUptime["mins"]+' 分'+data.serverInfo.serverUptime["secs"]+' 秒</span>');
            
            if(floats(setSize(data.networkStats.networks.eth0.tx,'mb'))>1024){
                var aaa_tx = floats(setSize(data.networkStats.networks.eth0.tx,'gb'))+"GB";
            } else{
                var aaa_tx = floats(setSize(data.networkStats.networks.eth0.tx,'mb'))+"MB";
            }
            if(floats(setSize(data.networkStats.networks.eth0.rx,'mb'))>1024){
                var aaa_rx = floats(setSize(data.networkStats.networks.eth0.rx,'gb'))+"GB";
            } else{
                var aaa_rx = floats(setSize(data.networkStats.networks.eth0.rx,'mb'))+"MB";
            }
        
            $("#eth").html('<span class="iosipa-order-state-3"><i class="mdui-icon material-icons">&#xe5d8;</i>&nbsp;'+aaa_tx+'</span>&nbsp;'+
            '<span class="iosipa-order-state-3"><i class="mdui-icon material-icons">&#xe5db;</i>&nbsp;'+aaa_rx+'</span>');
            
            
            $("#eth1").html('<span class="iosipa-order-state-3"><i class="mdui-icon material-icons">&#xe5d8;</i>&nbsp;'+ForDight(data.networkStats.networks.eth0.tx-se_tx,3)+'</span>&nbsp;'+
            '<span class="iosipa-order-state-3"><i class="mdui-icon material-icons">&#xe5db;</i>&nbsp;'+ForDight(data.networkStats.networks.eth0.rx-se_rx,3)+'</span>');
            se_tx = data.networkStats.networks.eth0.tx;
            se_rx = data.networkStats.networks.eth0.rx;
            if(floats(setSize(data.networkStats.networks.lo.tx,'mb'))>1024){
                var lo_tx = floats(setSize(data.networkStats.networks.lo.tx,'gb'))+"GB";
            } else{
                var lo_tx = floats(setSize(data.networkStats.networks.lo.tx,'mb'))+"MB";
            }
            if(floats(setSize(data.networkStats.networks.lo.rx,'mb'))>1024){
                var lo_rx = floats(setSize(data.networkStats.networks.lo.rx,'gb'))+"GB";
            } else{
                var lo_rx = floats(setSize(data.networkStats.networks.lo.rx,'mb'))+"MB";
            }
            
            $("#io").html('<span class="iosipa-order-state-3"><i class="mdui-icon material-icons">&#xe2c3;</i>&nbsp;'+lo_tx+'</span>&nbsp;'+
            '<span class="iosipa-order-state-3"><i class="mdui-icon material-icons">&#xe2c0;</i>&nbsp;'+lo_rx+'</span>');
            
            
            $("#io1").html('<span class="iosipa-order-state-3"><i class="mdui-icon material-icons">&#xe2c3;</i>&nbsp;'+ForDight(data.networkStats.networks.lo.tx-si_tx,3)+'</span>&nbsp;'+
            '<span class="iosipa-order-state-3"><i class="mdui-icon material-icons">&#xe2c0;</i>&nbsp;'+ForDight(data.networkStats.networks.lo.rx-si_rx,3)+'</span>');
            si_tx = data.networkStats.networks.lo.tx;
            si_rx = data.networkStats.networks.lo.rx;
        }
    });
}
function getNowFormatDate(){
    var date = new Date();
    var seperator1 = "-";
    var seperator2 = ":";
    var month = date.getMonth() + 1;
    var strDate = date.getDate();
    if (month >= 1 && month <= 9) {
      month = "0" + month;
    }
    if (strDate >= 0 && strDate <= 9) {
      strDate = "0" + strDate;
    }
    var currentdate = date.getFullYear() + seperator1 + month + seperator1 + strDate
          + " " + date.getHours() + seperator2 + date.getMinutes()
          + seperator2 + date.getSeconds();
    return currentdate;
}
function UserInfo(){
    $.ajax({
        type : "get",
        url : "https://api.qqij.cn/api/UserInfo/",
        async : true,
        beforeSend : function(){
            
        },
        complete : function(){
            
        },
        error : function(){
            UserInfo();
        },
        success : function(data){
            if(data!=null){
                if(data.data['location']==null){
                    UserInfo();
                }else{
                    $("#ip").html('<span class="iosipa-order-state-2">'+data.data['ip']+'</span>');
                    $("#address").html('<span class="iosipa-order-state-2">'+data.data['location']+'</span>');
                    $("#b").html('<span class="iosipa-order-state-2">'+data.data['browser']+'</span>');
                    $("#sys").html('<span class="iosipa-order-state-2">'+data.data['os']+'</span>');
                }
            }
        },
    });
};
$(document).ready(function(){
    clearInterval(window.getnet);
    clearInterval(window.info);
    window.getnet = setInterval(function(){
        
            state();
            $("#sys_times").html('<span class="iosipa-order-state-2">'+getNowFormatDate()+'</span>');
        
    },1000);
    UserInfo();
});
</script>
</html>
<?php
    function getUpTime() {  
        $uptime = (float) @file_get_contents("/proc/uptime");  
        $days = floor($uptime / 86400);  
        $hours = floor(($uptime % 86400) / 3600);  
        $minutes = floor((($uptime % 86400) % 3600) / 60);  
        $seconds = ($uptime % 3600) % 60;  
        //$time = $days.":".$hours.":".$minutes.":".$seconds;  
        return array(  
            'days' => $days,  
            'hours' => $hours,  
            'mins' => $minutes,  
            'secs' => $seconds 
        );
    }
    function GetLoad()
    {
        if (false === ($str = file_get_contents("/proc/loadavg")))
            return [];

        $loads = explode(' ', $str);
        if ($loads)
        {
            return [
                '1m'  => $loads[0],
                '5m'  => $loads[1],
                '15m' => $loads[2],
            ];
        }

        return [];
    }
    function GetCPUInfo()  
    {  
        $load = sys_getloadavg();  
        $user = $load[0];  
        $nice = $load[1];  
        $sys = $load[2];  
        $idle = 100.0 - $user - $nice - $sys;  
        $idle = number_format($idle, 2);
        return [  
            'user' => $user,  
            'nice' => $nice,  
            'sys' => $sys,  
            'idle' => $idle
        ];  
    }
    /**
     * 
     * 判断用户访问用的设备
     * 
     * */
    function isDesktopDevice() {  
        $userAgent = $_SERVER['HTTP_USER_AGENT'];  
        $mobileRegex = '/Mobi|Android|iPhone|iPad|Windows Phone|BlackBerry|IEMobile/';  
        if (preg_match($mobileRegex, $userAgent)) {  
            return false; // 移动设备  
        }  
        return true; // 电脑设备  
    }
    function GetMem(bool $bFormat = false)
    {
        if (false === ($str = file_get_contents("/proc/meminfo")))
            return [];

        preg_match_all("/MemTotal\s{0,}\:+\s{0,}([\d\.]+).+?MemFree\s{0,}\:+\s{0,}([\d\.]+).+?Cached\s{0,}\:+\s{0,}([\d\.]+).+?SwapTotal\s{0,}\:+\s{0,}([\d\.]+).+?SwapFree\s{0,}\:+\s{0,}([\d\.]+)/s", $str, $mems);
        preg_match_all("/Buffers\s{0,}\:+\s{0,}([\d\.]+)/s", $str, $buffers);

        $mtotal    = $mems[1][0] * 1024;
        $mfree     = $mems[2][0] * 1024;
        $mbuffers  = $buffers[1][0] * 1024;
        $mcached   = $mems[3][0] * 1024;
        $stotal    = $mems[4][0] * 1024;
        $sfree     = $mems[5][0] * 1024;
        $mused     = $mtotal - $mfree;
        $sused     = $stotal - $sfree;
        $mrealused = $mtotal - $mfree - $mcached - $mbuffers; //真实内存使用
        $rtn['mTotal']         = !$bFormat ? $mtotal : $this->size_format($mtotal, 1);
        $rtn['mFree']          = !$bFormat ? $mfree : $this->size_format($mfree, 1);
        $rtn['mBuffers']       = !$bFormat ? $mbuffers : $this->size_format($mbuffers, 1);
        $rtn['mCached']        = !$bFormat ? $mcached : $this->size_format($mcached, 1);
        $rtn['mUsed']          = !$bFormat ? ($mtotal - $mfree) : $this->size_format($mtotal - $mfree, 1);
        $rtn['mPercent']       = (floatval($mtotal) != 0) ? round($mused / $mtotal * 100, 1) : 0;
        $rtn['mRealUsed']      = !$bFormat ? $mrealused : $this->size_format($mrealused, 1);
        $rtn['mRealFree']      = !$bFormat ? ($mtotal - $mrealused) : $this->size_format($mtotal - $mrealused, 1);//真实空闲
        $rtn['mRealPercent']   = (floatval($mtotal) != 0) ? round($mrealused / $mtotal * 100, 1) : 0;             //真实内存使用率
        $rtn['mCachedPercent'] = (floatval($mcached) != 0) ? round($mcached / $mtotal * 100, 1) : 0;              //Cached内存使用率
        $rtn['swapTotal']      = !$bFormat ? $stotal : $this->size_format($stotal, 1);
        $rtn['swapFree']       = !$bFormat ? $sfree : $this->size_format($sfree, 1);
        $rtn['swapUsed']       = !$bFormat ? $sused : $this->size_format($sused, 1);
        $rtn['swapPercent']    = (floatval($stotal) != 0) ? round($sused / $stotal * 100, 1) : 0;
        $rtn['swapCached'] = $mbuffers;
        return $rtn;
    }
    function GetNetwork(bool $bFormat = false)
    {
        $rtn     = [];
        $netstat = file_get_contents('/proc/net/dev');
        if (false === $netstat)
        {
            return [];
        }

        $bufe = preg_split("/\n/", $netstat, -1, PREG_SPLIT_NO_EMPTY);
        foreach ($bufe as $buf)
        {
            if (preg_match('/:/', $buf))
            {
                list($dev_name, $stats_list) = preg_split('/:/', $buf, 2);
                $dev_name = trim($dev_name);

                $stats                        = preg_split('/\s+/', trim($stats_list));
                $rtn[$dev_name]['name']       = $dev_name;
                $rtn[$dev_name]['rx']    = !$bFormat ? $stats[0] : $this->netSize($stats[0]);
                $rtn[$dev_name]['in_packets'] = $stats[1];
                $rtn[$dev_name]['in_errors']  = $stats[2];
                $rtn[$dev_name]['in_drop']    = $stats[3];
                $rtn[$dev_name]['tx'] = !$bFormat ? $stats[8] : $this->netSize($stats[8]);
                $rtn[$dev_name]['out_packets'] = $stats[9];
                $rtn[$dev_name]['out_errors']  = $stats[10];
                $rtn[$dev_name]['out_drop']    = $stats[11];
            }
        }

        return $rtn;
    }

?>